using UnityEngine;
using TMPro;

#if UNITY_EDITOR
using UnityEditor;
#endif

[DisallowMultipleComponent]
[RequireComponent(typeof(RectTransform))]
[RequireComponent(typeof(CanvasRenderer))]
[AddComponentMenu("UI/TextMeshPro - Zero One", 12)]
[ExecuteAlways]
public class TextMeshProZO : TextMeshProUGUI
{
    public string localisationKey;

    public new void Start()
    {
        if (!string.IsNullOrEmpty(localisationKey))
		{
            text = Local.Get(localisationKey);
		}
        base.Start();
    }
}

#if UNITY_EDITOR

[CustomEditor(typeof(TextMeshProZO))]
public class TMP_Inspector : TMPro.EditorUtilities.TMP_EditorPanelUI
{
    public override void OnInspectorGUI()
    {
        serializedObject.Update();
        EditorGUILayout.PropertyField(serializedObject.FindProperty("localisationKey"));


        // Les 2 boutons
        GUILayout.BeginHorizontal();

        foreach (SystemLanguage s in Local.SupportedLanguages)
        {
            if (GUILayout.Button(s.ToString()))
            {
                Local.Init(s.ToString());
                TextMeshProZO tmppro = (TextMeshProZO)target;
                tmppro.text = Local.Get(tmppro.localisationKey);

                EditorUtility.SetDirty(tmppro);
            }
        }
        GUILayout.EndHorizontal();

        // On applique les modifications
        serializedObject.ApplyModifiedProperties();

        // On lance le rendu de base
        base.OnInspectorGUI();
    }
}

#endif